 ; Ŀ
 ;   Wog - draw a heat trace line.                                         
 ;   Copyright 1997, 2005, 2010 by Rocket Software Ltd.                    
 ;   Dedicated to the Wolf Cubs, after whose tie-holders it is named.      
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Llama - set the desired layer current, return an error if it is       
 ;   locked or frozen or off, make it if it doesn't exist.                 
 ;   Arguments: Lanam, a layer name.                                       
 ;              Lacol, a layer color.                                      
 ;              Lint, a linetype.                                          
 ;   Note: doesn't reset the properties for an exsting layer.              
 ;   Returns T if the layer is ok, else nil.                               
 ; 
 (DEFUN LLAMA (lanam lacol lint / revisp laset)
 ; Ŀ
 ;   See if the desired layer is ready to use.                             
 ; 
  (if (setq revisp (tblsearch "layer" lanam))
      (setq laset (layp lanam)))
 ; Ŀ
 ;   Act appropriately.                                                    
 ; 
  (cond ((and revisp (null laset))
         (setvar "clayer" lanam))
        ((null laset)
         (command "-layer" "m" lanam "c" lacol "" "lt" lint "" ""))
        (laset
         (prompt (strcat "\n* The " lanam " layer is " (car laset) ". *\n"))
         (exit)))
 (if laset t ()))
 ; Ŀ
 ;   Llama end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Wog - calculate points, feed them to the command.          
 ; 
 (DEFUN WOG (pa len / pb angg dist divs left lenbit flen)
  (setvar "osmode" osmo)
  (if (setq pb (getpoint pa "\nNext: "))
      (if (>= (distance pa pb) len)
          (progn
               (setvar "osmode" 0)
               (setq angg (angle pa pb))
               (setq dist (distance pa pb))
               (setq divs (fix (/ dist len)))        ; number of divisions
               (setq left (rem dist len))            ; remainder
               (setq lenbit (/ left divs))
               (setq flen (+ len lenbit))
               (command pa "a" "r" (* flen 0.55))
               (repeat divs
                       (setq pa (polar pa angg flen))
                       (command pa)))
          (command pb)))
 pb)
 ; Ŀ
 ;   Subroutine wog end.                                                   
 ; 

 ; Ŀ
 ;   Wog.                                                                  
 ; 
 (DEFUN C:WOG (/ clay osmo pwid *error* scal len pa plist pb angg)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq clay (getvar "clayer"))
  (setq osmo (getvar "osmode"))
  (setq pwid (getvar "plinewid"))
  (setvar "plinewid" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if clay (setvar "clayer" clay))
   (if osmo (setvar "osmode" osmo))
   (if pwid (setvar "plinewid" pwid))
   (command "undo" "end")
   (if (and shk (not (member (substr shk 1 1) '("q" "n"))))
       (write-line shk))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq scal (misps))
      (setq scal (getvar "dimscale")))
 ; Ŀ
 ;   Make sure the layer exists.                                           
 ; 
  (llama "htrace" "5" "continuous")
  (setq len (* 3 scal))              ; segment length
 ; Ŀ
 ;   Get the start point.                                                  
 ; 
  (setq pa (getpoint "Start: "))
  (setq plist (cons pa plist))
  (setvar "osmode" 0)
  (command "pline" pa)
 ; Ŀ
 ;   Call Wog to get segment ends and draw segments, returning a new       
 ;   start point each time.                                                
 ;   Save each point in the list Plist.                                    
 ; 
  (while (setq pa (wog pa len))
         (command "l" pa)
         (setq plist (cons pa plist)))
  (command "")
 ; Ŀ
 ;   The pline is finished, now add end blocks - end...                    
 ; 
  (setq pa (car plist))
  (setq pb (cadr plist))
  (setq angg (* 180 (/ (angle pb pa) pi)))
  (command "insert" "endseal" pa scal "" angg)
 ; Ŀ
 ;   ...and start.                                                         
 ; 
  (setq plist (reverse plist))
  (setq pa (car plist))
  (setq pb (cadr plist))
  (setq angg (* 180 (/ (angle pa pb) pi)))
  (command "insert" "heatconn" pa scal "" angg)
 ; Ŀ
 ;   End neatly by calling an imaginary function.                          
 ; 
  (krolp)
 (princ))